/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.bridge;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class FlatLafConfiguration {
    private static final String VERSION = "v1";
    private static final String PREFIX = "gui.laf.v1.";
    private static final String FLATLAF_PREFIX = "gui.laf.v1.flatlaf.";
    public static final String KEY_STATE = "gui.laf.v1.state";
    private static final String DEFAULT_STATE = State.AUTO.toString();
    private static final String DARK_THEME_PREFIX_NO_DOT = "gui.laf.v1.flatlaf.dark";
    private static final String LIGHT_THEME_PREFIX_NO_DOT = "gui.laf.v1.flatlaf.light";
    private static final String KEY_DARK_THEME_FILE = "gui.laf.v1.flatlaf.dark";
    private static final String KEY_LIGHT_THEME_FILE = "gui.laf.v1.flatlaf.light";
    private static final String DEFAULT_THEME_FILE = null;
    private static final String KEY_DARK_THEME_UI_PROPERTIES_FILE = "gui.laf.v1.flatlaf.dark.ui-properties-file";
    private static final String KEY_LIGHT_THEME_UI_PROPERTIES_FILE = "gui.laf.v1.flatlaf.light.ui-properties-file";
    private static final String DEFAULT_UI_PROPERTIES_FILE = null;
    private final State state;
    private final Map<Theme, String> themeFiles;
    private final Map<Theme, String> uiPropertiesFiles;

    public static String getVersion() {
        return VERSION;
    }

    public static Map<String, String> getDefaults() {
        LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
        defaults.put(KEY_STATE, DEFAULT_STATE);
        defaults.put("gui.laf.v1.flatlaf.dark", DEFAULT_THEME_FILE);
        defaults.put("gui.laf.v1.flatlaf.light", DEFAULT_THEME_FILE);
        defaults.put(KEY_DARK_THEME_UI_PROPERTIES_FILE, DEFAULT_UI_PROPERTIES_FILE);
        defaults.put(KEY_LIGHT_THEME_UI_PROPERTIES_FILE, DEFAULT_UI_PROPERTIES_FILE);
        return defaults;
    }

    public static FlatLafConfiguration parseFromMap(Map<String, String> map) {
        return new FlatLafConfiguration(FlatLafConfiguration.parseState(map.get(KEY_STATE)), map.getOrDefault("gui.laf.v1.flatlaf.dark", DEFAULT_THEME_FILE), map.getOrDefault(KEY_DARK_THEME_UI_PROPERTIES_FILE, DEFAULT_UI_PROPERTIES_FILE), map.getOrDefault("gui.laf.v1.flatlaf.light", DEFAULT_THEME_FILE), map.getOrDefault(KEY_LIGHT_THEME_UI_PROPERTIES_FILE, DEFAULT_UI_PROPERTIES_FILE));
    }

    public FlatLafConfiguration(State state, String darkThemeFile, String darkThemeUiPropertiesFile, String lightThemeFile, String lightThemeUiPropertiesFile) {
        this.state = state;
        LinkedHashMap<Theme, String> themeConfig = new LinkedHashMap<Theme, String>();
        themeConfig.put(Theme.DARK, darkThemeFile);
        themeConfig.put(Theme.LIGHT, lightThemeFile);
        this.themeFiles = Collections.unmodifiableMap(themeConfig);
        LinkedHashMap<Theme, String> uiPropertiesFiles = new LinkedHashMap<Theme, String>();
        uiPropertiesFiles.put(Theme.DARK, darkThemeUiPropertiesFile);
        uiPropertiesFiles.put(Theme.LIGHT, lightThemeUiPropertiesFile);
        this.uiPropertiesFiles = Collections.unmodifiableMap(uiPropertiesFiles);
    }

    public boolean isEnabled() {
        return this.state != null && this.state.isEnabled();
    }

    public Optional<State> getState() {
        return Optional.ofNullable(this.state);
    }

    public Map<Theme, String> getThemeFiles() {
        return this.themeFiles;
    }

    public Map<Theme, String> getUiPropertiesFiles() {
        return this.uiPropertiesFiles;
    }

    public Optional<Theme> getSelected() {
        if (this.state != null) {
            switch (this.state) {
                case LIGHT: {
                    return Optional.of(Theme.LIGHT);
                }
                case DARK: {
                    return Optional.of(Theme.DARK);
                }
            }
        }
        return Optional.empty();
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(KEY_STATE, this.getState().map(State::toString).orElse(null));
        map.put("gui.laf.v1.flatlaf.dark", this.getThemeFiles().get((Object)Theme.DARK));
        map.put("gui.laf.v1.flatlaf.light", this.getThemeFiles().get((Object)Theme.LIGHT));
        map.put(KEY_DARK_THEME_UI_PROPERTIES_FILE, this.getUiPropertiesFiles().get((Object)Theme.DARK));
        map.put(KEY_LIGHT_THEME_UI_PROPERTIES_FILE, this.getUiPropertiesFiles().get((Object)Theme.LIGHT));
        return map;
    }

    private static State parseState(Object o) {
        if (o != null) {
            String v = o.toString();
            for (State state : State.values()) {
                if (!state.toString().equals(v)) continue;
                return state;
            }
        }
        return null;
    }

    public static enum State {
        OFF(false),
        SYSTEM(false),
        AUTO,
        DARK,
        LIGHT;

        private final boolean enabled;

        private State(boolean enabled) {
            this.enabled = enabled;
        }

        private State() {
            this(true);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String toString() {
            return super.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Theme {
        DARK,
        LIGHT;


        public String toString() {
            return super.name().toLowerCase(Locale.ROOT);
        }
    }
}

